
var g_InsideCompactPaletteHeaders = false;
var g_DontCompactSceneBrowser = false;
var g_AnyChangeSinceLastPaletteSave = false;

function GetTabContent( TabId )
{
	if ( TabId == '' )
		return null;
		
	return window[ TabId + 'Content' ];
}

function GetTabContentStyle( TabId )
{
	var TabContent = GetTabContent( TabId );
	if ( TabContent == null )
		return null;
		
	return TabContent.style;
}

function GetTabContainer( Header )
{
	var tags = Header.getElementsByTagName( 'moi:tabcontainer' );
	if ( tags.length != 1 )
		return null;
		
	return tags.item(0);
}

function CompactPaletteHeaders( HeaderToIgnore )
{
	if ( g_InsideCompactPaletteHeaders )
		return;
		
	g_InsideCompactPaletteHeaders = true;

	var AmountToCompact = MiddleBody.scrollHeight - MiddleBody.clientHeight;

	var headers = document.getElementsByTagName( 'moi:paletteheader' );
	if ( headers.length <= 1 )
		return;

	// If there is no header to keep open passed in, then find the first open one
	// and use it as the one to keep open.
	if ( !HeaderToIgnore )
	{
		for ( var i = 0; i < headers.length; ++i )
		{	
			var Header = headers.item(i);
				
			if ( Header != CommandHeader && Header.activeTab != '' )
			{
				HeaderToIgnore = Header;
				break;
			}
		}
	}
	
	for ( var i = headers.length - 1; i >= 0; --i )
	{
		var Header = headers[i];
	
		if ( Header == HeaderToIgnore || Header == CommandHeader )
			continue;
			
		if ( g_DontCompactSceneBrowser && Header.id == 'SceneBrowserHeader' )
			continue;
			
		var TabContainer = GetTabContainer( Header );

		if ( AmountToCompact > 0 && TabContainer && TabContainer.activeTab != '' )
		{
			var TabContent = GetTabContent( TabContainer.activeTab );
			AmountToCompact -= TabContent.offsetHeight;
			
			TabContainer.activeTab = '';
			
			if ( AmountToCompact <= 0 )
				break;
		}
	}

	g_InsideCompactPaletteHeaders = false;
}

function SaveCommandPaletteState()
{
	g_AnyChangeSinceLastPaletteSave = false;
	
	var headers = document.getElementsByTagName( 'moi:paletteheader' );
	for ( var i = 0; i < headers.length; ++i )
	{
		var Header = headers.item(i);
		var TabContainer = GetTabContainer( Header );
		if ( TabContainer )
			TabContainer.activeTabSaved = TabContainer.activeTab;
	}
}

function RestoreCommandPaletteState()
{
	if ( g_AnyChangeSinceLastPaletteSave )
		return;
		
	g_AnyChangeSinceLastPaletteSave = true;

	var headers = document.getElementsByTagName( 'moi:paletteheader' );
	for ( var i = 0; i < headers.length; ++i )
	{
		var Header = headers.item(i);
		var TabContainer = GetTabContainer( Header );
		if ( TabContainer && TabContainer.activeTabSaved != TabContainer.activeTab )
			TabContainer.activeTab = TabContainer.activeTabSaved;
	}
}

function HandleTabChange( TabContainer )
{
	// If a tab was changed due to a click rather than by CompactPaletteHeaders, then
	// do not try to restore the previously saved state when the current command ends.
	if ( !g_InsideCompactPaletteHeaders )
		g_AnyChangeSinceLastPaletteSave = true;
	
	var PreviousStyle = GetTabContentStyle( TabContainer.previousActiveTab );
	var NewStyle = GetTabContentStyle( TabContainer.activeTab );
	
	if ( PreviousStyle != null )
	{
		PreviousStyle.visibility = 'hidden';
		PreviousStyle.height = '0px';
	}
	
	if ( NewStyle != null )
	{
		NewStyle.visibility = 'visible';
		NewStyle.height = 'auto';
	}
	
	if ( document.readyState == 'complete' && MiddleBody.scrollHeight > MiddleBody.clientHeight )
	{
		CompactPaletteHeaders( TabContainer.parentElement );
	}
}

function InitializeTabs()
{
	var Headers = document.getElementsByTagName( 'moi:paletteheader' );
	for ( var i = 0; i < Headers.length; ++i )
	{
		var TabContainer = GetTabContainer( Headers.item(i) );
		if ( TabContainer )
		{
			// Set up the ontabchange="" event handler.
			TabContainer.setAttribute( 'ontabchange', 'HandleTabChange(this);' );
			
			// Activate the first tab.
			var Tabs = TabContainer.getElementsByTagName( 'moi:tabbutton' );
			if ( Tabs.length > 0 )
				TabContainer.activeTab = Tabs.item(0).id;
		}
	}
}
